/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.ComboBoxEntry;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DDCCI;
import com.quantumdata.busmon.parser.HDCP;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.Parser;
import com.quantumdata.std.CECConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ButtonGroup bgCriteria;
    private JButton jButtonClose;
    private JButton jButtonFindNext;
    private JCheckBox jCheckBoxSearchBackwards;
    private JComboBox jComboBoxCEC;
    private JComboBox jComboBoxHDCP;
    private JComboBox jComboBoxVCP;
    private JFormattedTextField jFormattedTextFieldHex;
    private JRadioButton jRadioButtonASCII;
    private JRadioButton jRadioButtonCEC;
    private JRadioButton jRadioButtonEDID;
    private JRadioButton jRadioButtonHDCP;
    private JRadioButton jRadioButtonHex;
    private JRadioButton jRadioButtonVCP;
    private JTextField jTextASCII;

    public FindDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        Vector<ComboBoxEntry> vector = new Vector<ComboBoxEntry>();
        for (int i = 0; i < 255; ++i) {
            if (!DDCCI.isLegalCommand(i)) continue;
            vector.add(new ComboBoxEntry(i, DDCCI.getCommandName(i)));
        }
        this.jComboBoxVCP.setModel(new DefaultComboBoxModel(vector));
        Vector<ComboBoxEntry> vector2 = new Vector<ComboBoxEntry>();
        for (int i = 0; i < 255; ++i) {
            if (!HDCP.isLegalOpcode(116, i)) continue;
            vector2.add(new ComboBoxEntry(i, HDCP.getRegisterName(116, i)));
        }
        this.jComboBoxHDCP.setModel(new DefaultComboBoxModel(vector2));
        Vector<ComboBoxEntry> vector3 = new Vector<ComboBoxEntry>();
        for (int i = 0; i < 255; ++i) {
            if (!CECConstants.isLegalOpcode(i)) continue;
            vector3.add(new ComboBoxEntry(i, CECConstants.getCECOpcodeName(i)));
        }
        this.jComboBoxCEC.setModel(new DefaultComboBoxModel(vector3));
    }

    private void initComponents() {
        this.bgCriteria = new ButtonGroup();
        this.jRadioButtonASCII = new JRadioButton();
        this.jRadioButtonVCP = new JRadioButton();
        this.jRadioButtonHDCP = new JRadioButton();
        this.jTextASCII = new JTextField();
        this.jComboBoxVCP = new JComboBox();
        this.jComboBoxHDCP = new JComboBox();
        this.jButtonFindNext = new JButton();
        this.jButtonClose = new JButton();
        this.jRadioButtonEDID = new JRadioButton();
        this.jCheckBoxSearchBackwards = new JCheckBox();
        this.jRadioButtonHex = new JRadioButton();
        this.jFormattedTextFieldHex = new JFormattedTextField();
        this.jRadioButtonCEC = new JRadioButton();
        this.jComboBoxCEC = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Search for Packets");
        this.setResizable(false);
        this.bgCriteria.add(this.jRadioButtonASCII);
        this.jRadioButtonASCII.setSelected(true);
        this.jRadioButtonASCII.setText("ASCII String");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonASCII, gridBagConstraints);
        this.bgCriteria.add(this.jRadioButtonVCP);
        this.jRadioButtonVCP.setText("VCP Command");
        this.jRadioButtonVCP.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonVCP, gridBagConstraints);
        this.bgCriteria.add(this.jRadioButtonHDCP);
        this.jRadioButtonHDCP.setText("HDCP Register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonHDCP, gridBagConstraints);
        this.jTextASCII.setPreferredSize(new Dimension(200, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jTextASCII, gridBagConstraints);
        this.jComboBoxVCP.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jComboBoxVCP.setPreferredSize(new Dimension(300, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jComboBoxVCP, gridBagConstraints);
        this.jComboBoxHDCP.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jComboBoxHDCP.setOpaque(false);
        this.jComboBoxHDCP.setPreferredSize(new Dimension(300, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jComboBoxHDCP, gridBagConstraints);
        this.jButtonFindNext.setText("Find Next");
        this.jButtonFindNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.jButtonFindNextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.jButtonFindNext, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.jButtonCloseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 14;
        this.getContentPane().add((Component)this.jButtonClose, gridBagConstraints);
        this.bgCriteria.add(this.jRadioButtonEDID);
        this.jRadioButtonEDID.setText("EDID Packets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonEDID, gridBagConstraints);
        this.jCheckBoxSearchBackwards.setText("Search backwards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jCheckBoxSearchBackwards, gridBagConstraints);
        this.bgCriteria.add(this.jRadioButtonHex);
        this.jRadioButtonHex.setText("Hex String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonHex, gridBagConstraints);
        this.jFormattedTextFieldHex.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return new HexFormatter();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jFormattedTextFieldHex, gridBagConstraints);
        this.bgCriteria.add(this.jRadioButtonCEC);
        this.jRadioButtonCEC.setText("CEC Opcode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jRadioButtonCEC, gridBagConstraints);
        this.jComboBoxCEC.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jComboBoxCEC.setOpaque(false);
        this.jComboBoxCEC.setPreferredSize(new Dimension(300, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jComboBoxCEC, gridBagConstraints);
        this.pack();
    }

    private void jButtonFindNextActionPerformed(ActionEvent actionEvent) {
        this.findNext();
    }

    public void findNext() {
        int n;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        ListSelectionModel listSelectionModel = Sniffer.window.getTableSelectionModel();
        JTable jTable = Sniffer.window.getTable();
        int n2 = n = listSelectionModel.getLeadSelectionIndex();
        if (Parser.packets.getRowCount() == 0) {
            return;
        }
        if (n2 == -1) {
            n2 = 0;
        }
        while (!bl && bl2) {
            if (!this.jCheckBoxSearchBackwards.isSelected()) {
                if (++n2 == Parser.packets.getRowCount()) {
                    bl2 = false;
                }
            } else if (--n2 == -1) {
                bl2 = false;
            }
            if (bl3 && n2 == n) {
                JOptionPane.showMessageDialog(Sniffer.window, "No further packets meet your search criteria.");
                bl2 = false;
                continue;
            }
            if (!bl2) continue;
            if (this.jRadioButtonASCII.isSelected()) {
                if (!Parser.packets.getPacket(n2).getRawString().contains(this.jTextASCII.getText())) continue;
                bl = true;
                continue;
            }
            if (this.jRadioButtonHex.isSelected()) {
                if (!Parser.packets.getPacket(n2).getHexString().contains(this.jFormattedTextFieldHex.getText())) continue;
                bl = true;
                continue;
            }
            if (this.jRadioButtonVCP.isSelected()) {
                if (!Parser.packets.getPacket(n2).isDDCCI() || ((I2CDataBlock)Parser.packets.getPacket(n2).getDataBlock()).getMessage().getVCPCommand() != ((ComboBoxEntry)this.jComboBoxVCP.getSelectedItem()).getNumber()) continue;
                bl = true;
                continue;
            }
            if (this.jRadioButtonHDCP.isSelected()) {
                if (!Parser.packets.getPacket(n2).isHDCP() || ((I2CDataBlock)Parser.packets.getPacket(n2).getDataBlock()).getMessage().getHDCPRegister() != ((ComboBoxEntry)this.jComboBoxHDCP.getSelectedItem()).getNumber()) continue;
                bl = true;
                continue;
            }
            if (this.jRadioButtonEDID.isSelected()) {
                if (!Parser.packets.getPacket(n2).isEDID()) continue;
                bl = true;
                continue;
            }
            if (this.jRadioButtonCEC.isSelected()) {
                if (!Parser.packets.getPacket(n2).isCEC() || ((CECDataBlock)Parser.packets.getPacket(n2).getDataBlock()).getMessage().getOpcode() != ((ComboBoxEntry)this.jComboBoxCEC.getSelectedItem()).getNumber()) continue;
                bl = true;
                continue;
            }
            JOptionPane.showMessageDialog(Sniffer.window, "This search method is not yet implemented.");
        }
        if (bl) {
            listSelectionModel.clearSelection();
            listSelectionModel.setLeadSelectionIndex(n2);
            JViewport jViewport = (JViewport)jTable.getParent();
            Rectangle rectangle = jTable.getCellRect(n2, 0, true);
            Rectangle rectangle2 = jViewport.getViewRect();
            rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
            int n3 = (rectangle2.width - rectangle.width) / 2;
            int n4 = (rectangle2.height - rectangle.height) / 2;
            if (rectangle.x < n3) {
                n3 = -n3;
            }
            if (rectangle.y < n4) {
                n4 = -n4;
            }
            rectangle.translate(n3, n4);
            jViewport.scrollRectToVisible(rectangle);
        } else {
            JOptionPane.showMessageDialog(Sniffer.window, "No further packets found that match the search parameters.");
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new FindDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    class HexFormatter
    extends JFormattedTextField.AbstractFormatter {
        private static final long serialVersionUID = 1L;

        HexFormatter() {
        }

        public String valueToString(Object object) {
            if (object instanceof String) {
                String string = ((String)object).replaceAll("[^0-9a-fA-F]", "").toUpperCase();
                if ((string.length() & 1) == 1) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            return "";
        }

        public Object stringToValue(String string) {
            return new String(string);
        }
    }
}

